#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Slowly Swimming FractalMod01.fsh  by  mathmasterzach
//https://www.shadertoy.com/view/ttsXDB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Based on the original formula from http://paulbourke.net/fractals/magnet/
//Modified with different constants which change based on time and iteration

//Thanks to FabriceNeyret2 for some additional optimizations!
//Golfed version with 292 chars:
/*
#define S x-=1.+.5*sin((iTime+i)//
#define M mat2( z, -z.y, z )//
#define mainImage(O,U)                                  \
    float N=128., i=0., m=4., l=N;                      \
    for( vec2 n = iResolution.xy, z = n-n,              \
              u = 2.* ( U+U-n )/n.y;                    \
        i<N && l>0.;                                    \
         l =  4.-length(z=M*z) )                        \
         l < m ? m = l : m,                             \
         n = z+z + u,                                   \
         z = M*z + u,                                   \
         z.S/2.6),                             \
         z = M * vec2( n.S/2.)+.5, -n.y ) / dot(n,n),\
         O = m * ( cos(vec4(1,2,3,0)-5.*i++/N) + 1. ) / 8.
*/

float MAX_STEPS=128.;
float PI=acos(-1.);
float AA=2.;

#define vecMul(a,b) vec2(a.x*b.x-a.y*b.y,a.x*b.y+a.y*b.x)
#define vecDiv(a,b) vec2(a.x*b.x+a.y*b.y,a.y*b.x-a.x*b.y)/(b.x*b.x+b.y*b.y)

mat2 matRot(float a){
	float c=cos(a),
          s=sin(a);
    return mat2(c,s,s,-c);
}

vec3 samplePoint(vec2 c){
    float i;
    vec2 z=vec2(0.);
    float maxl=0.;
    for(i=0.;i<MAX_STEPS;i++){
        vec2 numer = vecMul(z,z)+c; numer.x-=1.+.5*sin((iTime+i)/2.6);
        vec2 denom = 2.*z+c;        denom.x-=1.5+.5*sin((iTime+i)/2.);
        vec2 div   = vecDiv(numer,denom);
        z = vecMul(div,div);
        float d=dot(z,z);
        if(d>16.){
            break;
        }
        maxl=max(maxl,d);
    }
    
    float ic=(5.*i/MAX_STEPS);
    return (4.-sqrt(maxl))*(cos(vec3(1,2,3)-ic)+1.)/8.;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 c=2.*(2.*fragCoord-iResolution.xy)/iResolution.y;
    float delt=(2./iResolution.y)/AA;
    vec3 col;
    for(float y=0.;y<AA;y++){
    	for(float x=0.;x<AA;x++){
    		col+=samplePoint(c+vec2(x,y)*delt);
    	}
    }
    col/=(AA*AA);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

